package com.example.karlosiladi.bazapodataka;

import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;

import java.util.List;

@Dao
public interface DaoAccess {
    @Insert
    void insertSingleProduct (Products product);
    @Insert
    void insertMultipleProducts (List<Products> productsList);
    @Query("SELECT * FROM Products WHERE productId = :productId")
    Products fetchProductByProductId (String productId);
    @Query("SELECT * FROM Products")
    List<Products> getProducts();
    @Update
    void updateProduct (Products product);
    @Delete
    void deleteProduct (Products product);
}
