package com.example.karlosiladi.bazapodataka;

import android.support.design.widget.TextInputEditText;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;

import java.util.List;


public class ProductInfoActivity extends AppCompatActivity {

    private TextInputEditText productIdEditText;
    private TextInputEditText productNameEditText;
    private TextInputEditText productPriceEditText;
    private Button submitButton;
    private ListView productsList;
    private ProductDatabase db;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_product_info_input);

        productIdEditText = findViewById(R.id.productId);
        productNameEditText = findViewById(R.id.productName);
        productPriceEditText = findViewById(R.id.productPrice);
        submitButton = findViewById(R.id.submitButton);
        db = ProductDatabase.getProductDatabase(ProductInfoActivity.this);

        // fill listView

        submitButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        Products product = new Products();
                        String productId = productIdEditText.getText().toString();
                        String productName = productNameEditText.getText().toString();
                        String productPrice = productPriceEditText.getText().toString();
                        if(productId != null && productName != null && productPrice != null) {
                            // clear edit texts

                            // fill object
                            product.setProductId(productId);
                            product.setProductName(productName);
                            product.setProductPrice(productPrice);
                            db.daoAccess().insertSingleProduct(product);
                            Log.d("Proizvod", (db.daoAccess().fetchProductByProductId(productId).getProductName()));
                            //Toast.makeText(ProductInfoActivity.this, "Proizvod uspješno unesen.", Toast.LENGTH_SHORT).show();
                        } else {
                            // krivi unos
                        }
                    }
                }).start();
            }
        });

    }
}
