/*
 * Pin layout should be as follows:
 * Signal     Pin                           Pin
 *            Arduino Uno           MFRC522 board
 * ------------------------------------------------------------
 * Reset      9                          RST
 * SPI SS     10                         SDA
 * SPI MOSI   11                         MOSI
 * SPI MISO   12                         MISO
 * SPI SCK    13                         SCK
 */

#include "rfid1.h"
#include "DFPlayer_Mini_Mp3.h"
#include <SoftwareSerial.h> 

#define MP3_RX 3
#define MP3_TX 4

#define BT_RX 5
#define BT_TX 6

/****** Deklaracija *****/
String formatSerNum(uchar *rfid_serNum);
String returnID( void );
int isReady( void );
void mp3play(int linija);

/***** DEFINOVI **+**/
#define NSS_PIN 10
#define RST_PIN 9
#define SCK_PIN 13
#define MISO_PIN 12
#define MOSI_PIN 11
#define IRQ_PIN 8

/**** GLOBALNE VARIJABLE ****/
unsigned char rfid_status;
unsigned char rfid_str[16];
unsigned char rfid_serNum[5]; 
boolean RFID_read = false;
String reading;
String ERROR_1 = "ERROR_1"; // Nije ocitano

// objekti
SoftwareSerial BT (BT_RX, BT_TX);
SoftwareSerial mySerial(MP3_RX, MP3_TX); // RX, TX
RFID1 rfid1;


void setup() {
    Serial.begin(9600);
    Serial.println ("Inicijaliziran UART!");

    BT.begin (9600);
    Serial.println ("Inicijaliziran BT!");

    rfid1.begin(IRQ_PIN,SCK_PIN,MOSI_PIN,MISO_PIN,NSS_PIN,RST_PIN);
    rfid1.init();
    Serial.println ("RFID inicijaliziran!");

    mySerial.begin (9600);
    mp3_set_serial (mySerial);
    delay(10);
    mp3_reset();
    delay(1000);
    mp3_set_volume (30); // value 0 ~ 30
    delay(10);
    Serial.println ("MP3 inicijaliziran!");
}

void loop() {
  String uid = returnID();
    if ( ERROR_1 != uid )
    {
       Serial.println ( uid );
       if(uid.equals("74606a7b")) {
        Serial.println ("Proizvod 1");
        BT.print("1\r\n");
        mp3play(1);
       }
       else if(uid.equals("3d84dd52")) {
        Serial.println ("Proizvod 2");
        BT.print("2\r\n");
        mp3play(2);
       } else if(uid.equals("8804d599")) {
          Serial.println ("Proizvod 3");
          BT.print("3\r\n");
          mp3play(3);
       }
       else if(uid.equals("8804dd99")) {
          Serial.println ("Proizvod 4");
          BT.print("4\r\n");
          mp3play(4);
       }
       else {
        BT.print(uid);
        BT.print("\r\n");
     }
    }
    
}

/* Function returns ID in String type */
String returnID( void ){
      delay(200);
      rfid_status = rfid1.request(PICC_REQIDL, rfid_str);  // Search card, return card types  
      if ( isReady() )
      {
      rfid_status = rfid1.anticoll(rfid_str);      // Prevent conflict, return the 4 bytes Serial number of the card
                                                   // INPUT   serNum--return the 4 bytes card serial number, the 5th byte is recheck byte
                                                   // RETURN   MI_OK if successed, MI_ERR if not
      if ( isReady() ) {  
        memcpy(rfid_serNum, rfid_str, 5);
        reading = formatSerNum(rfid_serNum);
        RFID_read = true;
      }
      delay(500);
      rfid1.halt();   // Command the card into sleep mode
                      // RETURN NONE, INPUT NONE      
      delay(500);
      RFID_read = false;
      
      return reading; 
   } 
return "ERROR_1";
}

/* Fuction checks if global variable rfid_status is equal to MI_OK */
int isReady( void )
 {
  if (rfid_status != MI_OK) 
  {
    //Serial.println(" Kartica nije ocitana ");     
    return 0;        
  }
  else 
   {
    return 1;
   }
   
}

/* Fuction format ID number and returns String */
String formatSerNum(uchar *rfid_serNum2) {
  int IDlen=4;
  String str; //pomocna varijabla
  for(int i=0; i<IDlen; i++){
    str.concat(String(0x0F & rfid_serNum2[i]>>4, HEX));
    str.concat(String(0x0F & rfid_serNum2[i], HEX));
  }
  return str;
}


void mp3play(int linija){
  Serial.print("Sviram ");
  Serial.println(linija);
  mp3_play(linija);
  delay(20000);
  mp3_reset();
  Serial.println("Gotovo.");
}
